$Title: (11) Value added by 126 RB and 18 AEZ                 

*----------------------------------------------------------------*
*                                                                *
*            Global Trade Analysis Project                       *
*                GTAP Water database                             *
*          (11) Value added by 126 RB and 18 AEZ                 *
*                                                                *
*----------------------------------------------------------------*

sets
  BAS /b1*b20/
  RB_NEW
  value /def, ref/
  ;
set
AGR_COMM(prod_comm)
LW /LND, WAT/
WATER_INDS /pdri, whti, groi, v_fi, osdi, c_bi, pfbi, ocri/
COVR /FORESTRY, LIVESTOCK, CROPLAND/
LTYPE /IRR, RFD/
;

AGR_COMM(prod_comm) = CROP_COMM(prod_comm) + NONCROP(prod_comm) ;
*AGR_COMM('frs') = no;
alias(a, AEZ18), (bas, BAS20)
;

parameter
  map_wat(bas360,bas,aez,value)
  map_lnd(aez360,bas,aez,value)
  map_bas(r,bas,*,value)
  ;
endw_comm(ENDW_COMM0) = yes;
endw_comm('land') = no;
endw_comm(bas360) = yes;
endw_comm(aez360) = yes;

$libinclude xlimport map_wat ../%AggrName%in/sets.xlsx wendw!a1
$libinclude xlimport map_lnd ../%AggrName%in/sets.xlsx lendw!a1
$libinclude xlimport map_bas ../%AggrName%in/sets.xlsx regbasins!a1:d500




* ---------------------- disaggregated version --------------------------

parameters
VFMO    VFM header for land and water by RB126-AEZ18 and IRR type   [[VFMO:AEZ18*RB*LW*AGR*LTYPE*REG]]
VFAO    EVFA header for land and water by RB126-AEZ18 and IRR type  [[VFAO:AEZ18*RB*LW*AGR*LTYPE*REG]]
VOAO    EVOA header for land and water by RB126-AEZ18- NO IRR type  [[VOAO:AEZ18*RB*LW*REG]]
WATO    Water use in m3 by RB126-AEZ18 and IRR type                 [[WATO:AEZ18*RB*CROP*LTYPE*REG]]
PRDO    Crop production in metric ton by RB126-AEZ18 and IRR type   [[PRDO:AEZ18*RB*CROP*LTYPE*REG]]
HVSO    Harvested area in hectare by RB126-AEZ18 and IRR type       [[HVSO:AEZ18*RB*CROP*LTYPE*REG]]
COVO    Land cover in hectare by RB126-AEZ18- NO IRR type           [[COVO:AEZ18*RB*COVR*REG]]
;
VFMO(AEZ18,RB,'LND',CROP,'IRR',REG) = vfm_("IrrLand",aez18,RB,crop,reg);
VFMO(AEZ18,RB,'LND',CROP,'RFD',REG) = vfm_("RfdLand",aez18,RB,crop,reg);
VFMO(AEZ18,RB,'WAT',CROP,'IRR',REG) = vfm_("Water"  ,aez18,RB,crop,reg);
VFMO(AEZ18,RB,'LND',NONCROP,'OTH',REG) = vfm_("OthLand",aez18,RB,noncrop,reg);

VFAO(AEZ18,RB,'LND',CROP,'IRR',REG) = evfa_("IrrLand",aez18,RB,crop,reg);
VFAO(AEZ18,RB,'LND',CROP,'RFD',REG) = evfa_("RfdLand",aez18,RB,crop,reg);
VFAO(AEZ18,RB,'WAT',CROP,'IRR',REG) = evfa_("Water"  ,aez18,RB,crop,reg);
VFAO(AEZ18,RB,'LND',NONCROP,'OTH',REG) = evfa_("OthLand",aez18,RB,noncrop,reg);

VOAO(AEZ18,RB,'WAT',REG) = evoa_("Water" ,aez18,RB,reg);
VOAO(AEZ18,RB,'LND',REG) =
   evoa_("OthLand",aez18,RB,reg) +
   evoa_("RfdLand",aez18,RB,reg) +
   evoa_("IrrLand",aez18,RB,reg) ;

WATO(AEZ18,RB,CROP,'IRR',REG) = volume('ww',AEZ18,RB,CROP,reg);
PRDO(AEZ18,RB,CROP,'IRR',REG) = volume('QI',AEZ18,RB,CROP,reg);
PRDO(AEZ18,RB,CROP,'RFD',REG) = volume('QR',AEZ18,RB,CROP,reg);
HVSO(AEZ18,RB,CROP,'IRR',REG) = volume('HI',AEZ18,RB,CROP,reg);
HVSO(AEZ18,RB,CROP,'RFD',REG) = volume('HR',AEZ18,RB,CROP,reg);
COVO(AEZ18,RB,'FORESTRY' ,REG)= volume('COVER',AEZ18,RB,'FRS',reg);
COVO(AEZ18,RB,'LIVESTOCK',REG)= volume('COVER',AEZ18,RB,'CTL',reg);
COVO(AEZ18,RB,'CROPLAND' ,REG)= volume('COVER',AEZ18,RB,'OAP',reg);
* %%%%%%%%%% WARNING OAP IS USED FOR CROPLAND %%%%%%%%%%
